/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import sun.rmi.transport.proxy.CGIClientException;
import sun.rmi.transport.proxy.CGICommandHandler;
import sun.rmi.transport.proxy.CGIForwardCommand;
import sun.rmi.transport.proxy.CGIGethostnameCommand;
import sun.rmi.transport.proxy.CGIPingCommand;
import sun.rmi.transport.proxy.CGIServerException;
import sun.rmi.transport.proxy.CGITryHostnameCommand;

public final class CGIHandler {
    static int ContentLength;
    static String QueryString;
    static String RequestMethod;
    static String ServerName;
    static int ServerPort;
    private static CGICommandHandler[] commands;
    private static Hashtable commandLookup;

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ContentLength = Integer.getInteger("CONTENT_LENGTH", 0);
                QueryString = System.getProperty("QUERY_STRING", "");
                RequestMethod = System.getProperty("REQUEST_METHOD", "");
                ServerName = System.getProperty("SERVER_NAME", "");
                ServerPort = Integer.getInteger("SERVER_PORT", 0);
                return null;
            }
        });
        commands = new CGICommandHandler[]{new CGIForwardCommand(), new CGIGethostnameCommand(), new CGIPingCommand(), new CGITryHostnameCommand()};
        commandLookup = new Hashtable();
        for (int i2 = 0; i2 < commands.length; ++i2) {
            commandLookup.put(commands[i2].getName(), commands[i2]);
        }
    }

    private CGIHandler() {
    }

    private static void returnClientError(String string) {
        System.out.println("Status: 400 Bad Request: " + string);
        System.out.println("Content-type: text/html");
        System.out.println("");
        System.out.println("<HTML><HEAD><TITLE>Java RMI Client Error</TITLE></HEAD><BODY>");
        System.out.println("<H1>Java RMI Client Error</H1>");
        System.out.println("");
        System.out.println(string);
        System.out.println("</BODY></HTML>");
        System.exit(1);
    }

    private static void returnServerError(String string) {
        System.out.println("Status: 500 Server Error: " + string);
        System.out.println("Content-type: text/html");
        System.out.println("");
        System.out.println("<HTML><HEAD><TITLE>Java RMI Server Error</TITLE></HEAD><BODY>");
        System.out.println("<H1>Java RMI Server Error</H1>");
        System.out.println("");
        System.out.println(string);
        System.out.println("</BODY></HTML>");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            String string2;
            int n2 = QueryString.indexOf("=");
            if (n2 == -1) {
                string2 = QueryString;
                string = "";
            } else {
                string2 = QueryString.substring(0, n2);
                string = QueryString.substring(n2 + 1);
            }
            CGICommandHandler cGICommandHandler = (CGICommandHandler)commandLookup.get(string2);
            if (cGICommandHandler != null) {
                try {
                    cGICommandHandler.execute(string);
                }
                catch (CGIClientException cGIClientException) {
                    CGIHandler.returnClientError(cGIClientException.getMessage());
                }
                catch (CGIServerException cGIServerException) {
                    CGIHandler.returnServerError(cGIServerException.getMessage());
                }
            } else {
                CGIHandler.returnClientError("invalid command: " + string2);
            }
        }
        catch (Exception exception) {
            CGIHandler.returnServerError("internal error: " + exception.getMessage());
        }
        System.exit(0);
    }
}

